/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.datamodel.impl;

import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ExpressionEnabled;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmEditableComboBoxModel;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Hmc_DataItemNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Hmc_ModelExpressionNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.TextNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.event.NodeTreeEvent;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.event.NodeTreeListener;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.AbstractDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ValueDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MutableListModelTreeImpl
implements PmEditableComboBoxModel,
NodeTreeListener,
ExpressionEnabled {
    private static final String TRACE_MASKT = "XPMDLMTT";
    private static final String TRACE_MASKF = "XPMDLMTF";
    private Node modelRoot;
    private List data;
    private List evalExpr;
    private Map mapping;
    private int selectionPolicy;
    private Method getList;
    private Method getSelected;
    private Method setSelected;
    private int[] selected;
    private String editableText = "";
    private static final Class[] CLASS_ARGS_SET_SELECTED = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MutableListModelTreeImpl.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] CLASS_ARGS_SET_SELECTION = new Class[]{array$Lcom$ibm$ui$framework$ValueDescriptor == null ? (array$Lcom$ibm$ui$framework$ValueDescriptor = MutableListModelTreeImpl.class$("[Lcom.ibm.ui.framework.ValueDescriptor;")) : array$Lcom$ibm$ui$framework$ValueDescriptor};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Lcom$ibm$ui$framework$ValueDescriptor;

    public MutableListModelTreeImpl(Node modelRoot) {
        Trace.trace(TRACE_MASKF, "MLMTI: <ctor> root node is: " + modelRoot);
        this.modelRoot = modelRoot;
        this.data = new ArrayList();
        this.evalExpr = new ArrayList();
        this.mapping = new HashMap();
        this.selected = new int[0];
        modelRoot.getDocumentRoot().addNodeTreeListener(this);
    }

    public String getModelId() {
        String id = this.modelRoot.getParent().fetchAttribute("hmc", "model", false, false);
        return id == null ? "" : id;
    }

    public void setSelectionPolicy(int selectionPolicy) {
        this.selectionPolicy = selectionPolicy;
    }

    public int getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void init() {
        Trace.trace(TRACE_MASKF, "MLMTI: init()");
        String isMultiple = this.modelRoot.fetchAttribute("acvt", "isMultiple", false, true);
        this.selectionPolicy = isMultiple != null && isMultiple.equals("true") ? 2 : 0;
        this.refresh();
    }

    public void refresh() {
        if (this.selected != null && this.selected.length > 0 && this.selected[0] == this.data.size() && this.data.size() > 0) {
            Trace.trace(TRACE_MASKF, "skipping refresh, we're on the editable value");
        } else {
            this.data.clear();
            this.mapping.clear();
            this.evalExpr.clear();
            this.selected = new int[0];
            this.populateFromBean();
            if (this.data.size() == 0) {
                this.populateFromMarkup();
            }
            this.populateSelection();
        }
    }

    private void populateSelection() {
        PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
        if (bean instanceof DataBean && this.getSelected != null) {
            try {
                if (this.selectionPolicy == 2) {
                    AbstractDescriptor[] descriptors = (AbstractDescriptor[])this.getSelected.invoke((Object)bean, null);
                    if (descriptors == null) {
                        this.setSelectedCompat(new String[0]);
                    } else {
                        String[] selectedItems = new String[descriptors.length];
                        for (int i = 0; i < selectedItems.length; ++i) {
                            selectedItems[i] = descriptors[i] != null ? descriptors[i].getName() : null;
                        }
                        this.setSelectedCompat(selectedItems);
                    }
                } else {
                    String selectedItem = (String)this.getSelected.invoke((Object)bean, null);
                    if (selectedItem != null) {
                        this.setSelectedCompat(new String[]{selectedItem});
                    }
                }
                Trace.trace(TRACE_MASKF, "MLMTI: populateFromBean()-- set selected items to ListModel");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "MLMTI: populateFromBean()-- exception getting selected value: " + e.getMessage());
            }
        }
    }

    private void populateFromBean() {
        PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
        if (bean instanceof DataBean) {
            String binding = this.modelRoot.fetchAttribute("hmc", "binding_id", false);
            binding = binding.substring(0, 1).toUpperCase() + binding.substring(1);
            Trace.trace(TRACE_MASKF, "MLMTI: populateFromBean()-- binding: " + binding);
            if (binding != null && !binding.equals("")) {
                if (this.getList == null) {
                    try {
                        this.getList = bean.getClass().getMethod("get" + binding + "List", null);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding getList (uppercase)");
                    }
                }
                if (this.getSelected == null) {
                    try {
                        this.getSelected = this.selectionPolicy == 2 ? bean.getClass().getMethod("get" + binding + "Selection", null) : bean.getClass().getMethod("get" + binding, null);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding getSelected (uppercase)");
                    }
                }
                if (this.setSelected == null) {
                    try {
                        this.setSelected = this.selectionPolicy == 2 ? bean.getClass().getMethod("set" + binding + "Selection", CLASS_ARGS_SET_SELECTION) : bean.getClass().getMethod("set" + binding, CLASS_ARGS_SET_SELECTED);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding setSelected (uppercase)");
                    }
                }
                binding = binding.substring(0, 1).toLowerCase() + binding.substring(1);
                if (this.getList == null) {
                    try {
                        this.getList = bean.getClass().getMethod("get" + binding + "List", null);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding getList (lowercase)");
                    }
                }
                if (this.getSelected == null) {
                    try {
                        this.getSelected = this.selectionPolicy == 2 ? bean.getClass().getMethod("get" + binding + "Selection", null) : bean.getClass().getMethod("get" + binding, null);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding getSelected (lowercase)");
                    }
                }
                if (this.setSelected == null) {
                    try {
                        this.setSelected = this.selectionPolicy == 2 ? bean.getClass().getMethod("set" + binding + "Selection", CLASS_ARGS_SET_SELECTION) : bean.getClass().getMethod("set" + binding, CLASS_ARGS_SET_SELECTED);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI - exception finding getSelected (lowercase)");
                    }
                }
                if (this.getList != null) {
                    try {
                        AbstractDescriptor[] values = (AbstractDescriptor[])this.getList.invoke((Object)bean, null);
                        if (values != null) {
                            for (int i = 0; i < values.length; ++i) {
                                if (values[i] == null) continue;
                                this.addElementCompat(values[i].getTitle(), values[i].getName());
                            }
                        }
                        Trace.trace(TRACE_MASKF, "MLMTI: populateFromBean()-- added all elements to ListModel");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI: populateFromBean()-- exception retrieving list: " + e.getMessage());
                    }
                }
            }
        }
    }

    private void populateFromMarkup() {
        List children = this.modelRoot.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Trace.trace(TRACE_MASKF, "MLMTI: init() considering child");
            Node child = (Node)iterator.next();
            if (child == null || !(child instanceof Hmc_DataItemNode)) continue;
            String id = child.getId();
            String value = child.fetchAttribute("hmc", "value", true);
            if (id != null && !id.equals("")) {
                Trace.trace(TRACE_MASKF, "MLMTI: init() adding to named map");
                this.mapping.put(id, value);
            }
            Trace.trace(TRACE_MASKF, "MLMTI: init() adding to data set");
            this.data.add(value);
        }
    }

    public void setEditableText(String text) {
        Trace.trace(TRACE_MASKF, "MLMTI: setEditableText(" + text + ")");
        if (text == null) {
            text = "";
        }
        this.editableText = text;
        if (this.selected != null && this.selected.length > 0 && this.selected[0] == this.data.size()) {
            try {
                PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
                if (this.selectionPolicy != 2) {
                    this.setSelected.invoke((Object)bean, text);
                }
                Trace.trace(TRACE_MASKF, "MLMTI: setEditableText(" + text + ")");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "MLMTI: setEditableText()-- error setting selection into bean.  Rethrowing..");
                String msg = null;
                if (e instanceof InvocationTargetException && (msg = ((InvocationTargetException)e).getCause().getLocalizedMessage()) == null) {
                    msg = ((InvocationTargetException)e).getCause().getMessage();
                }
                if (msg == null) {
                    msg = e.getLocalizedMessage();
                }
                if (msg == null) {
                    msg = e.getMessage();
                }
                if (msg == null) {
                    msg = "";
                }
                throw new RuntimeException(msg, e);
            }
        }
    }

    public void removeElementAt(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.data.size()) {
            throw new IllegalArgumentException("Index specified was invalid for list operation (" + index + ")");
        }
        this.removeElementAtCompat(index);
    }

    public void removeElementAtCompat(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.data.size()) {
            throw new IllegalArgumentException("Index specified was invalid for list operation (" + index + ")");
        }
        Trace.trace(TRACE_MASKF, "MLMTI: removing element at index: " + index);
        Object dataVal = this.data.get(index);
        Object key = null;
        Set keys = this.mapping.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object tmpKey = iterator.next();
            if (!this.mapping.get(tmpKey).equals(dataVal)) continue;
            key = tmpKey;
        }
        this.mapping.remove(key);
        this.data.remove(index);
    }

    public void addElement(String element) {
        this.data.add(element);
    }

    public void addElementCompat(String element, String elementId) {
        if (elementId == null || elementId.equals("")) {
            this.data.add(element);
        } else {
            Trace.trace(TRACE_MASKF, "MLMTI: add element with id: " + element + "," + elementId);
            this.mapping.put(elementId, element);
            this.data.add(element);
        }
    }

    public void insertElementAt(String element, int index) {
        if (index < 0 || index >= this.data.size()) {
            this.data.add(element);
        } else {
            this.data.add(index, element);
        }
    }

    public void insertElementAtCompat(String element, String elementId, int index) {
        Trace.trace(TRACE_MASKF, "MLMTI: insert element with id at: " + element + "," + elementId + "," + index);
        if (index < 0 || index >= this.data.size()) {
            this.data.add(element);
        } else {
            this.data.add(index, element);
        }
        if (elementId != null && !elementId.equals("")) {
            this.mapping.put(elementId, element);
        }
    }

    public void removeElement(String element) {
        Trace.trace(TRACE_MASKF, "MLMTI: remove element: " + element);
        this.data.remove(element);
    }

    public void removeElementCompat(String elementId) {
        if (elementId == null || elementId.equals("")) {
            throw new IllegalArgumentException("Element ID can not be null or the empty string for compatiblity mode operations");
        }
        Trace.trace(TRACE_MASKF, "MLMTI: remove element id: " + elementId);
        Object elementVal = this.mapping.get(elementId);
        this.mapping.remove(elementId);
        this.data.remove(elementVal);
    }

    public int getSize() {
        return this.data.size();
    }

    public String getElementAt(int index) throws IllegalArgumentException {
        if (index < 0 || index > this.data.size()) {
            throw new IllegalArgumentException("Index specified was invalid for list operation (" + index + ")");
        }
        if (index >= this.evalExpr.size()) {
            return (String)this.data.get(index);
        }
        return (String)this.evalExpr.get(index);
    }

    public int[] getSelected() {
        Trace.trace(TRACE_MASKF, "MLMTI: getSelected() ");
        return this.selected;
    }

    public void setSelected(int[] selected) {
        block17: {
            Trace.trace(TRACE_MASKF, "MLMTI: setSelected() ");
            this.selected = selected == null ? new int[0] : selected;
            if (this.setSelected != null) {
                if (selected != null) {
                    for (int i = 0; i < selected.length; ++i) {
                        Trace.trace(TRACE_MASKF, "selected[" + i + "]: " + selected[i]);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "selected[] was null");
                }
                PmDataBean bean = this.modelRoot.getPanelModel().getDataBean();
                if (selected.length == 0) {
                    try {
                        if (this.selectionPolicy == 2) {
                            this.setSelected.invoke((Object)bean, new Object[]{new ValueDescriptor[0]});
                            break block17;
                        }
                        this.setSelected.invoke((Object)bean, "");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "MLMTI: setSelected()-- error setting empty selection into bean ");
                    }
                } else {
                    String[] vals = this.getSelectedCompat();
                    if (vals != null && vals.length > 0 && vals[0] != null) {
                        try {
                            if (this.selectionPolicy == 2) {
                                String s = "";
                                ValueDescriptor[] vds = new ValueDescriptor[vals.length];
                                for (int i = 0; i < vds.length; ++i) {
                                    String title = (String)this.data.get(selected[i]);
                                    String name = null;
                                    Iterator iterator = this.mapping.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        Map.Entry entry = iterator.next();
                                        if (entry.getValue() != title) continue;
                                        name = (String)entry.getKey();
                                    }
                                    vds[i] = new ValueDescriptor(name, title);
                                    if (i > 0) {
                                        s = s + ",";
                                    }
                                    s = s + vals[i] + "/" + this.data.get(selected[i]);
                                }
                                this.setSelected.invoke((Object)bean, new Object[]{vds});
                                Trace.trace(TRACE_MASKF, "MLMTI: setSelected(" + s + ")");
                            } else {
                                this.setSelected.invoke((Object)bean, vals[0]);
                                Trace.trace(TRACE_MASKF, "MLMTI: setSelected(" + vals[0] + ")");
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "MLMTI: setSelected()-- error setting selection into bean ");
                            if (e.getCause() == null || !(e.getCause() instanceof IllegalUserDataException)) break block17;
                            Trace.trace(TRACE_MASKF, "MLMTI: setSelected()-- error was IllegalUserDataException, rethrowing");
                            throw (IllegalUserDataException)e.getCause();
                        }
                    }
                }
            }
        }
    }

    public String[] getSelectedCompat() {
        Trace.trace(TRACE_MASKF, "MLMTI: getSelectedCompat() ");
        String[] selectedNames = new String[this.selected.length];
        Set keys = this.mapping.keySet();
        for (int i = 0; i < this.selected.length; ++i) {
            String value = this.selected[i] == this.data.size() ? this.editableText : (this.selected[i] < 0 ? "" : (i >= this.evalExpr.size() ? this.data.get(this.selected[i]) : this.evalExpr.get(this.selected[i])));
            selectedNames[i] = value;
        }
        return selectedNames;
    }

    public void setSelectedCompat(String[] selectedNames) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "MLMTI: setSelectedCompat() ");
        if (selectedNames == null) {
            Trace.trace(TRACE_MASKF, "MLMTI: setSelectedCompat - no selection");
            this.selected = new int[0];
        } else {
            int[] oldSelected = this.selected;
            this.selected = new int[selectedNames.length];
            for (int i = 0; i < this.selected.length; ++i) {
                if (selectedNames[i] == null || selectedNames[i].equals("")) {
                    this.selected = oldSelected;
                    throw new IllegalArgumentException("Element ID can not be null or the empty string for compatiblity mode operations");
                }
                Trace.trace(TRACE_MASKF, "setSelectedCompat[" + i + "]: " + selectedNames[i]);
                this.selected[i] = this.data.indexOf(selectedNames[i]);
                if (this.selected[i] == -1) {
                    this.selected[i] = this.data.indexOf(this.mapping.get(selectedNames[i]));
                }
                if (this.selected[i] != -1) continue;
                throw new IllegalArgumentException("Data mapping & list model do not contain element: " + selectedNames[i]);
            }
        }
    }

    public boolean containsHmcId(String id) {
        return this.mapping.containsKey(id);
    }

    public Object getValueByHmcId(String id) {
        return this.mapping.get(id);
    }

    public Hmc_ModelExpressionNode[] getExpressionNodes() {
        Node tmpParent = null;
        List children = this.modelRoot.getParent().getParent().getChildren();
        int childrenLength = children.size();
        for (int i = 1; i < childrenLength; ++i) {
            if (children.get(i) != this) continue;
            tmpParent = (Node)children.get(i--);
            while (tmpParent != null && tmpParent instanceof TextNode) {
                if (i == 0) {
                    tmpParent = null;
                    continue;
                }
                tmpParent = (Node)children.get(i--);
            }
            i = childrenLength;
        }
        if (tmpParent == null) {
            tmpParent = this.modelRoot.getParent().getParent();
        }
        Hmc_ModelExpressionNode[] nodes = new Hmc_ModelExpressionNode[this.data.size()];
        for (int i = 0; i < nodes.length; ++i) {
            Properties p = new Properties();
            p.put("modelType", "list");
            p.put("modelID", this.getModelId());
            Object txt = this.data.get(i);
            p.put("text", txt == null ? "" : txt);
            p.put("index", new Integer(i).toString());
            nodes[i] = new Hmc_ModelExpressionNode(tmpParent, p);
        }
        return nodes;
    }

    public void setExpression(String text, int index) {
        if (this.evalExpr.size() > index) {
            Trace.trace(TRACE_MASKF, "removing expr " + index);
            this.evalExpr.remove(index);
        }
        Trace.trace(TRACE_MASKF, "adding expr " + index + " (" + text + ")");
        this.evalExpr.add(index, text);
    }

    public void nodeAdded(NodeTreeEvent event) {
        Node node;
        Trace.trace(TRACE_MASKF, "MLMTI: nodeAdded() ");
        Node parent = (Node)event.getSource();
        if (parent == this.modelRoot && (node = event.getNode()) instanceof Hmc_DataItemNode) {
            List children = parent.getChildren();
            int childIndex = children.indexOf(node);
            String id = node.getId();
            String value = node.fetchAttribute("hmc", "value", true);
            if (id != null && !id.equals("")) {
                this.insertElementAtCompat(value, id, childIndex);
            } else {
                this.insertElementAt(value, childIndex);
            }
        }
    }

    public void nodeRemoved(NodeTreeEvent event) {
        Node node;
        Trace.trace(TRACE_MASKF, "MLMTI: nodeRemoved() ");
        Node parent = (Node)event.getSource();
        if (parent == this.modelRoot && (node = event.getNode()) instanceof Hmc_DataItemNode) {
            String id = node.getId();
            String value = node.fetchAttribute("hmc", "value", true);
            if (id != null && !id.equals("")) {
                this.removeElementCompat(id);
            } else {
                this.removeElement(value);
            }
        }
    }

    public String[] getSelectedNames() {
        String[] selectedNames = new String[this.selected.length];
        Set keys = this.mapping.keySet();
        for (int i = 0; i < this.selected.length; ++i) {
            String value = this.selected[i] == this.data.size() ? this.editableText : this.data.get(this.selected[i]);
            if (value != null) {
                boolean found = false;
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    if (this.mapping.get(key) == null || !this.mapping.get(key).equals(value)) continue;
                    selectedNames[i] = (String)key;
                    found = true;
                }
                if (found || !(value instanceof String)) continue;
                selectedNames[i] = value;
                continue;
            }
            selectedNames[i] = "";
        }
        return selectedNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

